<?php

//doctor.php

include('../class/Appointment.php');

$object = new Appointment;

if(!$object->is_login())
{
    header("location:".$object->base_url."admin");
}

if($_SESSION['arsiparis_type'] != 'Admin')
{
    header("location:".$object->base_url."");
}

include('header.php');

?>

	<!-- Page Heading -->
	<!-- h1 class="h3 mb-4 text-gray-800">Arsiparis Manajemen</h1-->

	<!-- DataTales Example -->
	<span id="message"></span>
	<div class="card shadow mb-4">
		<div class="card-header py-3">
			<div class="row">
				<div class="col">
					<h6 class="m-0 font-weight-bold text-primary">Data Arsiparis</h6>
				</div>
				<div class="col" align="right">
					<button type="button" name="add_arsiparis" id="add_arsiparis" class="btn btn-success btn-circle btn-sm"><i class="fas fa-plus"></i></button>
				</div>
			</div>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-bordered" id="arsiparis_table" width="100%" cellspacing="0">
					<thead>
						<tr>
							<th>Foto</th>
							<th>Email</th>
							<th>Nama</th>
							<th>Jabatan</th>
							<th>Status</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
						
					</tbody>
				</table>
			</div>
		</div>
	</div>

	<?php
	include('footer.php');
	?>

<div id="arsiparisModal" class="modal fade">
  	<div class="modal-dialog">
    	<form method="post" id="arsiparis_form">
      		<div class="modal-content">
        		<div class="modal-header">
          			<h4 class="modal-title" id="modal_title">Add Arsiparis</h4>
          			<button type="button" class="close" data-dismiss="modal">&times;</button>
        		</div>
        		<div class="modal-body">
        			<span id="form_message"></span>
		          	<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Email <span class="text-danger">*</span></label>
                                <input type="text" name="arsiparis_email_address" id="arsiparis_email_address" class="form-control" required data-parsley-type="email" data-parsley-trigger="keyup" />
                            </div>
                            <div class="col-md-6">
                                <label>Password <span class="text-danger">*</span></label>
                                <input type="password" name="arsiparis_password" id="arsiparis_password" class="form-control" required  data-parsley-trigger="keyup" />
                            </div>
		          		</div>
		          	</div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>NIP <span class="text-danger">*</span></label>
                                <input type="text" name="arsiparis_nip" id="arsiparis_nip" class="form-control" required data-parsley-pattern="/^[0-9 \s]+$/" data-parsley-trigger="keyup" />
                            </div>
                            <div class="col-md-6">
                                <label>Nama<span class="text-danger">*</span></label>
                                <input type="text" name="arsiparis_name" id="arsiparis_name" class="form-control" required  data-parsley-trigger="keyup" />
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Jabatan<span class="text-danger">*</span></label>
                                <input type="text" name="arsiparis_position" id="arsiparis_position" class="form-control" required data-parsley-trigger="keyup"/>
                            </div>
                            <div class="col-md-6">
                                <label>No Telp</label>
                                <input type="text" name="arsiparis_phone" id="arsiparis_phone" class="form-control" data-parsley-trigger="keyup"/>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Foto Profil</label>
                        <br />
                        <input type="file" name="arsiparis_profile_image" id="arsiparis_profile_image" />
                        <div id="uploaded_image"></div>
                        <input type="hidden" name="hidden_arsiparis_profile_image" id="hidden_arsiparis_profile_image" />
                    </div>
        		</div>
        		<div class="modal-footer">
          			<input type="hidden" name="hidden_id" id="hidden_id" />
          			<input type="hidden" name="action" id="action" value="Add" />
          			<input type="submit" name="submit" id="submit_button" class="btn btn-success" value="Add" />
          			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        		</div>
      		</div>
    	</form>
  	</div>
</div>

<script>
$(document).ready(function(){

	var dataTable = $('#arsiparis_table').DataTable({
		"processing" : true,
		"serverSide" : true,
		"order" : [],
		"ajax" : {
			url:"arsiparis_action.php",
			type:"POST",
			data:{action:'fetch'}
		},
		"columnDefs":[
			{
				"targets":[0, 1, 2, 4, 5],
				"orderable":false,
			},
		],
	});
	

    $('#doctor_date_of_birth').datepicker({
        format: "yyyy-mm-dd",
        autoclose: true
    });

	$('#add_arsiparis').click(function(){
		
		$('#arsiparis_form')[0].reset();

		$('#arsiparis_form').parsley().reset();

    	$('#modal_title').text('Tambah Arsiparis');
		
		$('#arsiparis_email_address').attr('disabled', false);	
		$('#arsiparis_nip').attr('disabled', false);

    	$('#action').val('Add');

    	$('#submit_button').val('Tambah');

    	$('#arsiparisModal').modal('show');

    	$('#form_message').html('');

	});

	$('#arsiparis_form').parsley();

	$('#arsiparis_form').on('submit', function(event){
		event.preventDefault();
		if($('#arsiparis_form').parsley().isValid())
		{	
			//
			$('#arsiparis_email_address').attr('disabled', false);	
			$('#arsiparis_nip').attr('disabled', false);
			//
			$.ajax({
				url:"arsiparis_action.php",
				method:"POST",
				data: new FormData(this),
				dataType:'json',
                contentType: false,
                cache: false,
                processData:false,
				beforeSend:function()
				{
					$('#submit_button').attr('disabled', 'disabled');
					$('#submit_button').val('wait...');
				},
				success:function(data)
				{
					
					$('#submit_button').attr('disabled', false);
					if(data.error != '')
					{
						$('#form_message').html(data.error);
						$('#submit_button').val('Tambah');
					}
					else
					{
						$('#arsiparisModal').modal('hide');
						$('#message').html(data.success);
						dataTable.ajax.reload();

						setTimeout(function(){

				            $('#message').html('');

				        }, 5000);
					}
				}
			})
		}
	});

	$(document).on('click', '.edit_button', function(){

		var arsiparis_nip = $(this).data('id');

		$('#arsiparis_form').parsley().reset();

		$('#form_message').html('');

		$.ajax({

	      	url:"arsiparis_action.php",

	      	method:"POST",

	      	data:{arsiparis_nip:arsiparis_nip, action:'fetch_single'},

	      	dataType:'JSON',

	      	success:function(data)
	      	{

	        	$('#arsiparis_email_address').val(data.arsiparis_email_address);
                $('#arsiparis_password').val(data.arsiparis_password);
                $('#arsiparis_name').val(data.arsiparis_name);
                $('#uploaded_image').html('<img src="'+data.arsiparis_profile_image+'" class="img-fluid img-thumbnail" width="150" />')
                $('#hidden_arsiparis_profile_image').val(data.arsiparis_profile_image);
				$('#arsiparis_profile_image').val("");
                $('#arsiparis_phone').val(data.arsiparis_phone);
                $('#arsiparis_position').val(data.arsiparis_position);
				$('#arsiparis_nip').val(data.arsiparis_nip);
                
	        	$('#modal_title').text('Edit Arsiparis');

	        	$('#action').val('Edit');

	        	$('#submit_button').val('Edit');
				$('#arsiparis_email_address').attr("disabled", true) ;
				$('#arsiparis_nip').attr("disabled", true) ;

	        	$('#arsiparisModal').modal('show');

	        	$('#hidden_id').val(arsiparis_nip);

	      	}

	    })

	});

	$(document).on('click', '.status_button', function(){
		var id = $(this).data('id');
    	var status = $(this).data('status');
		var next_status = 'enable';
		if(status == 'enable')
		{
			next_status = 'disabled';
		}
		if(confirm("Are you sure you want to "+next_status+" it?"))
    	{

      		$.ajax({

        		url:"arsiparis_action.php",

        		method:"POST",

        		data:{id:id, action:'change_status', status:status, next_status:next_status},

        		success:function(data)
        		{

          			$('#message').html(data);

          			dataTable.ajax.reload();

          			setTimeout(function(){

            			$('#message').html('');

          			}, 5000);

        		}

      		})

    	}
	});

});
</script>