<?php

//doctor_action.php

include('../class/Appointment.php');

$object = new Appointment;

if(isset($_POST["action"]))
{
	if($_POST["action"] == 'fetch')
	{
		$order_column = array('arsiparis_image','arsiparis_email','arsiparis_name','arsiparis_position');

		$output = array();

		$main_query = "
		SELECT * FROM arsiparis_table ";

		$search_query = '';
		
		if(isset($_POST["search"]["value"]))
		{
			$search_query .= 'WHERE arsiparis_email LIKE "%'.$_POST["search"]["value"].'%" ';
			$search_query .= 'OR arsiparis_name LIKE "%'.$_POST["search"]["value"].'%" ';
			$search_query .= 'OR arsiparis_hp LIKE "%'.$_POST["search"]["value"].'%" ';
		}

		if(isset($_POST["order"]))
		{
			$order_query = 'ORDER BY '.$order_column[$_POST['order']['0']['column']].' '.$_POST['order']['0']['dir'].' ';
		}
		else
		{
			$order_query = 'ORDER BY arsiparis_nip DESC ';
		}

		$limit_query = '';

		if($_POST["length"] != -1)
		{
			$limit_query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}

		$object->query = $main_query . $search_query . $order_query;

		$object->execute();

		$filtered_rows = $object->row_count();

		$object->query .= $limit_query;

		$result = $object->get_result();

		$object->query = $main_query;

		$object->execute();

		$total_rows = $object->row_count();

		$data = array();

		foreach($result as $row)
		{
			$sub_array = array();
			$sub_array[] = '<img src="'.$row["arsiparis_image"].'" class="img-thumbnail" width="75" />';
			$sub_array[] = $row["arsiparis_email"];
			$sub_array[] = $row["arsiparis_name"];
			$sub_array[] = $row["arsiparis_position"];
			$status = '';
			if($row["login_status"] == 'enable') $status = '<button type="button" name="status_button" class="btn btn-primary btn-sm status_button" data-id="'.$row["arsiparis_nip"].'" data-status="'.$row["login_status"].'">Enable</button>';
			else $status = '<button type="button" name="status_button" class="btn btn-danger btn-sm status_button" data-id="'.$row["arsiparis_nip"].'" data-status="'.$row["login_status"].'">Disabled</button>';
			$sub_array[] = $status;
			$sub_array[] = '
			<div align="center">
			<button type="button" name="edit_button" class="btn btn-warning btn-circle btn-sm edit_button" data-id="'.$row["arsiparis_nip"].'"><i class="fas fa-edit"></i></button>
			<button type="button" name="delete_button" class="btn btn-danger btn-circle btn-sm delete_button" data-id="'.$row["arsiparis_nip"].'"><i class="fas fa-times"></i></button>
			</div>
			';
			$data[] = $sub_array;
		}

		$output = array(
			"draw"    			=> 	intval($_POST["draw"]),
			"recordsTotal"  	=>  $total_rows,
			"recordsFiltered" 	=> 	$filtered_rows,
			"data"    			=> 	$data
		);
			
		echo json_encode($output);

	}

	if($_POST["action"] == 'Add')
	{
		$error = '';

		$success = '';

		$data = array(
			':arsiparis_email_address'	=>	$_POST["arsiparis_email_address"]
		);

		$object->query = "
		SELECT * FROM arsiparis_table 
		WHERE arsiparis_email = :arsiparis_email_address
		";

		$object->execute($data);

		if($object->row_count() > 0)
		{
			$error = '<div class="alert alert-danger">Email Address Already Exists</div>';
		}
		else
		{
			$arsiparis_profile_image = '';
			if($_FILES['arsiparis_profile_image']['name'] != '')
			{
				$allowed_file_format = array("jpg", "png");

	    		$file_extension = pathinfo($_FILES["arsiparis_profile_image"]["name"], PATHINFO_EXTENSION);

	    		if(!in_array($file_extension, $allowed_file_format))
			    {
			        $error = "<div class='alert alert-danger'>Upload valiid file. jpg, png</div>";
			    }
			    else if (($_FILES["arsiparis_profile_image"]["size"] > 2000000))
			    {
			       $error = "<div class='alert alert-danger'>File size exceeds 2MB</div>";
			    }
			    else
			    {
			    	$new_name = rand() . '.' . $file_extension;

					$destination = '../images/' . $new_name;

					move_uploaded_file($_FILES['arsiparis_profile_image']['tmp_name'], $destination);

					$arsiparis_profile_image = $destination;
			    }
			}
			else
			{
				$character = $_POST["arsiparis_name"][0];
				$path = "../images/". time() . ".png";
				$image = imagecreate(200, 200);
				$red = rand(0, 255);
				$green = rand(0, 255);
				$blue = rand(0, 255);
			    imagecolorallocate($image, 230, 230, 230);  
			    $textcolor = imagecolorallocate($image, $red, $green, $blue);
			    imagettftext($image, 100, 0, 55, 150, $textcolor, '../font/arial.ttf', $character);
			    imagepng($image, $path);
			    imagedestroy($image);
			    $doctor_profile_image = $path;
			}

			if($error == '')
			{
				$data = array(
					':arsiparis_email_address'			=>	$object->clean_input($_POST["arsiparis_email_address"]),
					':arsiparis_password'				=>	$_POST["arsiparis_password"],
					':arsiparis_name'					=>	$object->clean_input($_POST["arsiparis_name"]),
					':arsiparis_profile_image'			=>	$arsiparis_profile_image,
					':arsiparis_phone_no'				=>	$object->clean_input($_POST["arsiparis_phone"]),
					':arsiparis_nip'					=>	$object->clean_input($_POST["arsiparis_nip"]),
					':arsiparis_position'				=>	$object->clean_input($_POST["arsiparis_position"]),
					//':doctor_degree'				=>	$object->clean_input($_POST["doctor_degree"]),
					//':doctor_expert_in'				=>	$object->clean_input($_POST["doctor_expert_in"]),
					//':doctor_status'				=>	'Active',
					//':doctor_added_on'				=>	$object->now
				);

				$object->query = "
				INSERT INTO arsiparis_table 
				(arsiparis_nip, arsiparis_email, arsiparis_password, arsiparis_name, arsiparis_image, arsiparis_hp, arsiparis_position) 
				VALUES (:arsiparis_nip, :arsiparis_email_address, :arsiparis_password, :arsiparis_name, :arsiparis_profile_image, :arsiparis_phone_no, :arsiparis_position)
				";

				$object->execute($data);

				$success = '<div class="alert alert-success">Arsiparis Added</div>';
			}
		}

		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);

		echo json_encode($output);

	}

	if($_POST["action"] == 'fetch_single')
	{
		$object->query = "
		SELECT * FROM arsiparis_table 
		WHERE arsiparis_nip = '".$_POST["arsiparis_nip"]."'
		";

		$result = $object->get_result();

		$data = array();

		foreach($result as $row)
		{
			$data['arsiparis_email_address'] = $row['arsiparis_email'];
			$data['arsiparis_password'] = $row['arsiparis_password'];
			$data['arsiparis_name'] = $row['arsiparis_name'];
			$data['arsiparis_profile_image'] = $row['arsiparis_image'];
			$data['arsiparis_phone'] = $row['arsiparis_hp'];
			$data['arsiparis_position'] = $row['arsiparis_position'];
			$data['arsiparis_nip'] = $row['arsiparis_nip'];
			//$data['doctor_date_of_birth'] = $row['doctor_date_of_birth'];
			//$data['doctor_degree'] = $row['doctor_degree'];
			//$data['doctor_expert_in'] = $row['doctor_expert_in'];
		}

		echo json_encode($data);
	}

	if($_POST["action"] == 'Edit')
	{
		$error = '';

		$success = '';
		
		$data = array(
			':arsiparis_email_address'	=>	$_POST["arsiparis_email_address"],
			':arsiparis_nip'			=>	$_POST['hidden_id']
		);
		
		$object->query = "
		SELECT * FROM arsiparis_table 
		WHERE arsiparis_email = :arsiparis_email_address 
		AND arsiparis_nip != :arsiparis_nip
		";
		
		$object->execute($data);

		if($object->row_count() > 0)
		{
			$error = '<div class="alert alert-danger">Email Address Already Exists</div>';
		}
		else
		{
			$arsiparis_profile_image = $_POST["hidden_arsiparis_profile_image"];

			if($_FILES['arsiparis_profile_image']['name'] != '')
			{
				$allowed_file_format = array("jpg", "png");

	    		$file_extension = pathinfo($_FILES["arsiparis_profile_image"]["name"], PATHINFO_EXTENSION);

	    		if(!in_array($file_extension, $allowed_file_format))
			    {
			        $error = "<div class='alert alert-danger'>Upload valid file. jpg, png</div>";
			    }
			    else if (($_FILES["arsiparis_profile_image"]["size"] > 2000000))
			    {
			       $error = "<div class='alert alert-danger'>File size exceeds 2MB</div>";
			    }
			    else
			    {
			    	$new_name = rand() . '.' . $file_extension;

					$destination = '../images/' . $new_name;

					move_uploaded_file($_FILES['arsiparis_profile_image']['tmp_name'], $destination);

					$arsiparis_profile_image = $destination;
			    }
			}

			if($error == '')
			{
				$data = array(
					':arsiparis_email_address'			=>	$object->clean_input($_POST["arsiparis_email_address"]),
					':arsiparis_password'				=>	$_POST["arsiparis_password"],
					':arsiparis_name'					=>	$object->clean_input($_POST["arsiparis_name"]),
					':arsiparis_profile_image'			=>	$arsiparis_profile_image,
					':arsiparis_phone_no'				=>	$object->clean_input($_POST["arsiparis_phone"]),
					':arsiparis_position'				=>	$object->clean_input($_POST["arsiparis_position"])
					//':doctor_date_of_birth'			=>	$object->clean_input($_POST["doctor_date_of_birth"]),
					//':doctor_degree'				=>	$object->clean_input($_POST["doctor_degree"]),
					//':doctor_expert_in'				=>	$object->clean_input($_POST["doctor_expert_in"])
				);

				$object->query = "
				UPDATE arsiparis_table SET 
				arsiparis_hp = '".$data[':arsiparis_phone_no']."',
				arsiparis_password = '".$data[':arsiparis_password']."' ,
				arsiparis_name = '".$data[':arsiparis_name']."',
				arsiparis_image = '".$data[':arsiparis_profile_image']."', 
				arsiparis_position = '".$data[':arsiparis_position']."'
				WHERE arsiparis_nip = '".$_POST['hidden_id']."'
				";

				$object->execute($data);
				
				$success = '<div class="alert alert-success">Arsiparis Data Updated </div>';
			}	
		}
		//$success = '<div class="alert alert-success">Arsiparis Data Updated'.$_POST["arsiparis_email_address"].'  </div>';
		//$error = '<div class="alert alert-success">Arsiparis Data Updated'.$_POST["arsiparis_email_address"].'  </div>';
		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);

		echo json_encode($output);

	}
	

	if($_POST["action"] == 'change_status')
	{
		$data = array(
			':login_status'		=>	$_POST['next_status']
		);

		$object->query = "
		UPDATE arsiparis_table 
		SET login_status = :login_status 
		WHERE arsiparis_nip = '".$_POST["id"]."'
		";

		$object->execute($data);

		echo '<div class="alert alert-success">Class Status change to '.$_POST['next_status'].'</div>';
	}

}

?>