<?php

//olah.php

include('../class/Appointment.php');

$object = new Appointment;

if(!$object->is_login())
{
    header("location:".$object->base_url."admin");
}

/*if($_SESSION['arsiparis_type'] != 'Admin')
	{
		header("location:".$object->base_url."");
	}*/

include('header.php');

?>
<span id="message"></span>
<div class="card shadow mb-4">
	<div class="card-header py-3">
		<div class="row">
			<div class="col">
				<h6 class="m-0 font-weight-bold text-primary">Arsip Inaktif</h6>
			</div>
			<div class="col" align="right">
				<button type="button" name="add_data" id="add_data" class="btn btn-success btn-circle btn-sm"><i class="fas fa-plus"></i></button>
			</div>
		</div>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table id="user_data" class="table table-bordered" width="100%" cellspacing="0">
			 <thead>
			  <tr>
			   <th>kode klasifikasi</th>
			   <th>unit kerja</th>
			   <th>uraian</th>
			   <th>kurun waktu</th>
			   <th></th>
			  </tr>
			 </thead>
			 <tbody>
             </tbody>
			</table>
		</div>
	</div>
</div>
<button type="button" name="klasifikasi" id="klasifikasi" class="btn btn-success btn-primary btn-sm">klasifikasi</button>
<?php
include('footer.php');
?>
<div id="dataModal"  class="modal fade">
  	<div class="modal-dialog">
    	<form method="post" id="data_form">
      		<div class="modal-content">
        		<div class="modal-header">
          			<h4 class="modal-title" id="modal_title">Tambah Data</h4>
          			<button type="button" class="close" data-dismiss="modal">&times;</button>
        		</div>
        		<div class="modal-body">
        			<span id="form_message"></span>
		          	<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Unit Kerja <span class="text-danger">*</span></label>
								<select name="unit_kerja" id="unit_kerja" class="form-control" data-parsley-trigger="change">
									<option value="">-Unit Kerja-</option>
									<option value="ROUM">Biro Umum</option>
									<option value="TU">Bag Tata Usaha</option>
									<option value="LOGISTIK">Bag Logistik</option>
									<option value="HUMAS">Biro Humpro</option>
									<option value="PENCEGAHAN">Dit Pencegahan</option>
									<option value="REHABILITASI">Dit Rehabilitasi</option>
								</select>
                                <!--input type="text" name="unit_kerja" id="unit_kerja" class="form-control" required  data-parsley-trigger="keyup" /-->
                            </div>
							<div class="col-md-6">
                                <label>Kode Klasifikasi <span class="text-danger"></span></label>
                                <input type="text" name="kode_klasifikasi" id="kode_klasifikasi" class="form-control" data-parsley-trigger="keyup" />
                            </div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
							<div class="col-md-6">
                                <label>No Arsip <span class="text-danger"></span></label>
                                <input type="text" name="no_arsip" id="no_arsip" class="form-control" data-parsley-trigger="keyup" />
                            </div>
                            <div class="col-md-6">
                                <label>Kurun Waktu <span class="text-danger"></span></label>
                                <input type="text" name="kurun_waktu" id="kurun_waktu" class="form-control" data-parsley-trigger="keyup" />
                            </div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
                            <div class="col-md-12">
                                <label>Uraian <span class="text-danger">*</span></label>
								<textarea rows=4 name="uraian" id="uraian" class="form-control" required ></textarea>
							</div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Media <span class="text-danger">*</span></label>
                                <input type="text" name="media" id="media" class="form-control" required data-parsley-trigger="keyup" />
                            </div>
                            <div class="col-md-6">
                                <label>Kondisi <span class="text-danger">*</span></label>
								<select name="kondisi" id="kondisi" class="form-control" required data-parsley-trigger="change">
									<option value="">-Kondisi-</option>
									<option value="Baik">Baik</option>
									<option value="Rusak">Rusak</option>
								</select>
                                <!--input type="text" name="kondisi" id="kondisi" class="form-control" required  data-parsley-trigger="keyup" /-->
                            </div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Box </label>
                                <input type="text" name="box" id="box" class="form-control" data-parsley-trigger="keyup" />
                            </div>
							<div class="col-md-6">
                                <label>Tingkat Perkembangan <span class="text-danger"></span></label>
								<select name="tingkat_perkembangan" id="tingkat_perkembangan" class="form-control" data-parsley-trigger="change">
									<option value="">-Tingkat Perkembangan-</option>
									<option value="Asli">Asli</option>
									<option value="Copy">Copy</option>
									<option value="Asli/Copy">Asli/Copy</option>
								</select>
                                <!--input type="text" name="tingkat_perkembangan" id="tingkat_perkembangan" class="form-control" data-parsley-trigger="keyup" /-->
                            </div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Ruang </label>
								<select name="ruang" id="ruang" class="form-control" data-parsley-trigger="change">
									<option value="">-Pilih Ruang-</option>
									<option value="A">Ruang A</option>
									<option value="B">Ruang B</option>
									<option value="C">Ruang C</option>
								</select>
                                <!--input type="text" name="ruang" id="ruang" class="form-control" data-parsley-trigger="keyup" /-->
                            </div>
                            <div class="col-md-6">
                                <label>Rak <span class="text-danger"></span></label>
                                <input type="text" name="rak" id="rak" class="form-control" data-parsley-trigger="keyup" />
                            </div>
		          		</div>
		          	</div>
					<div class="form-group">
                        <div class="row">
							<div class="col-md-6">
                                <label>Keterangan <span class="text-danger"></span></label>
								<select name="keterangan" id="keterangan" class="form-control" data-parsley-trigger="change">
									<option value="">-Keterangan-</option>
									<option value="BIASA">Biasa</option>
									<option value="RAHASIA">Rahasia</option>
								</select>
                                <!--input type="text" name="keterangan" id="keterangan" class="form-control" data-parsley-trigger="keyup" /-->
                            </div>
							<div class="col-md-6">
								<label>Arsiparis <span class="text-danger"></span></label>
								<input type="text" name="nama_arsiparis" id="nama_arsiparis" class="form-control" readonly data-parsley-trigger="keyup" />
							</div>
						</div>
					</div>
					
					<div class="modal-footer">
          			<input type="hidden" name="hidden_id" id="hidden_id" />
          			<input type="hidden" name="action" id="action" value="Add" />
          			<input type="submit" name="submit" id="submit_button" class="btn btn-success" value="Add" />
          			<button type="button" class="btn btn-default" data-dismiss="modal" data-backdrop="static" data-keyboard="false">Close</button>
        		</div>
			</div>
    	</form>
  	</div>
</div>


<script type="text/javascript" language="javascript" >
 $(document).ready(function(){
  
  var dataTable = $('#user_data').DataTable({
		"processing" : true,
		"serverSide" : true,
		"order" : [],
		"ajax" : {
			url:"inaktif_action.php",
			type:"POST",
			data:{action:'fetch'}
		},
		"columnDefs":[
			{
				"targets":[2,4],
				"orderable":false,
			},
		],
	});
	
	$('#add_data').click(function(){
		
		$('#data_form')[0].reset();

		$('#data_form').parsley().reset();

    	$('#modal_title').text('Tambah Data');

    	$('#action').val('Add');

    	$('#submit_button').val('Simpan');
		<?php
			$object->query = "
			SELECT arsiparis_name FROM arsiparis_table 
			WHERE arsiparis_nip = '".$_SESSION['arsiparis_id']."'
			";

			$result = $object->get_result();
			
			foreach($result as $row)
			{
				echo "$('#nama_arsiparis').val('".$row['arsiparis_name']."');";
			}
		?>
		$('#dataModal').modal({backdrop: 'static', keyboard: false}) ;
    	$('#dataModal').modal('show');

    	$('#form_message').html('');

	});
	
	$('#data_form').parsley();
  
	$(document).on('click', '.edit_button', function(){

		var no_urut = $(this).data('id');

		$('#data_form').parsley().reset();

		$('#form_message').html('');

		$.ajax({

	      	url:"inaktif_action.php",

	      	method:"POST",

	      	data:{no_urut:no_urut, action:'fetch_single'},

	      	dataType:'JSON',

	      	success:function(data)
	      	{

	        	$('#kode_klasifikasi').val(data.kode_klasifikasi);
                $('#unit_kerja').val(data.unit_kerja);
                $('#kurun_waktu').val(data.kurun_waktu);
				$('#no_arsip').val(data.no_arsip);
				$('#tingkat_perkembangan').val(data.tingkat_perkembangan);
				$('#media').val(data.media);
				$('#kondisi').val(data.kondisi);
				$('#box').val(data.box);
				$('#ruang').val(data.ruang);
				$('#rak').val(data.rak);
				$('#uraian').val(data.uraian);
				$('#keterangan').val(data.keterangan);
				$('#nama_arsiparis').val(data.nama_arsiparis);
                
	        	$('#modal_title').text('Ubah Data');

	        	$('#action').val('Edit');

	        	$('#submit_button').val('Ubah');
				
	        	$('#dataModal').modal('show');

	        	$('#hidden_id').val(no_urut);

	      	}

	    })

	});
	
	$('#data_form').on('submit', function(event){
		event.preventDefault();
		if($('#data_form').parsley().isValid())
		{	
			$.ajax({
				url:"inaktif_action.php",
				method:"POST",
				data: new FormData(this),
				dataType:'json',
                contentType: false,
                cache: false,
                processData:false,
				beforeSend:function()
				{
					$('#submit_button').attr('disabled', 'disabled');
					$('#submit_button').val('wait...');
				},
				success:function(data)
				{
					
					$('#submit_button').attr('disabled', false);
					if(data.error != '')
					{
						$('#form_message').html(data.error);
						$('#submit_button').val('Add');
					}
					else
					{
						$('#dataModal').modal('hide');
						$('#message').html(data.success);
						dataTable.ajax.reload();

						setTimeout(function(){

				            $('#message').html('');

				        }, 5000);
					}
				}
			})
		}
	});
	
	
	$(document).on("click","#klasifikasi",function() {
			
			window.open('klasifikasi.php', "myWindow", "width=700,height=400");
	});
 
 });
</script>

