<?php

//doctor_action.php
require_once '../vendor/autoload.php';
include('../class/Appointment.php');

//
use PhpOffice\PhpWord\TemplateProcessor;

//
$object = new Appointment;

if(isset($_POST["action"]))
{
	if($_POST["action"] == 'fetch')
	{
		$order_column = array('jenis_naskah','nomor','tujuan','klasifikasi','satker','tanggal','tanda_tangan','template');

		$output = array();
	
		$main_query = "
		SELECT id_surat,kode_naskah,jenis_naskah.jenis_naskah,nomor,perihal,tujuan,klasifikasi,satuan_kerja,tanggal,tanda_tangan,template,surat_keluar.status FROM surat_keluar INNER JOIN jenis_naskah,satuan_kerja,tanda_tangan WHERE surat_keluar.jenis_naskah=jenis_naskah.kode_naskah AND satuan_kerja.kode_satker=surat_keluar.satker AND ttd=tanda_tangan.kode_ttd ";
		$search_query = '';

		if(isset($_POST["search"]["value"]))
		{
			$search_query .= 'AND (nomor LIKE "%'.$_POST["search"]["value"].'%" ';
			$search_query .= 'OR perihal LIKE "'.$_POST["search"]["value"].'" '; 
			$search_query .= 'OR tujuan LIKE "%'.$_POST["search"]["value"].'%") '; 
		}

		if(isset($_POST["order"]))
		{
			$order_query = 'ORDER BY '.$order_column[$_POST['order']['0']['column']].' '.$_POST['order']['0']['dir'].' ';
		}
		else
		{
			$order_query = 'ORDER BY id_surat DESC ';
		}

		$limit_query = '';

		if($_POST["length"] != -1)
		{
			$limit_query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}

		$object->query = $main_query . $search_query . $order_query;

		$object->execute();

		$filtered_rows = $object->row_count();

		$object->query .= $limit_query;

		$result = $object->get_result();

		$object->query = $main_query;

		$object->execute();

		$total_rows = $object->row_count();

		$data = array();

		$status = '';

		foreach($result as $row)
		{
			$sub_array = array();
			$sub_array[] = $row["jenis_naskah"];
			$sub_array[] = $row["nomor"];
			$sub_array[] = $row["perihal"];
			$sub_array[] = $row["tujuan"];
			//$sub_array[] = $row["klasifikasi"];
			$sub_array[] = $row["satuan_kerja"];
			$sub_array[] = $row["tanggal"];
			$sub_array[] = $row["tanda_tangan"];
			$file_extension = pathinfo($row["template"], PATHINFO_EXTENSION);
			if($file_extension=='docx')
			{
				$sub_array[] = '<center><a href="'.$row["template"].'"><i class="fas fa-file-word" style="font-size:36px;color:blue"></i></a></center>';
			}
				else {
				$sub_array[] = '<center><a href="'.$row["template"].'"><i class="fas fa-file-pdf" style="font-size:36px;color:red"></i></a></center>';
			}
			if($row["status"] == 0) {
				
				$status = '<button type="button" name="status_button" class="btn btn-primary btn-sm status_button" data-id="'.$row["id_surat"].'" data-status="'.$row["kode_naskah"].'"> Approve </button>';
				
			} else $status = '';
			
			$sub_array[] = $status;
			$sub_array[] = '
			<div align="center">
			<button type="button" name="edit_button" class="btn btn-warning btn-circle btn-sm edit_button" data-id="'.$row["id_surat"].'"><i class="fas fa-edit"></i></button>
			</div>
			';
			$data[] = $sub_array;
		}

		$output = array(
			"draw"    			=> 	intval($_POST["draw"]),
			"recordsTotal"  	=>  $total_rows,
			"recordsFiltered" 	=> 	$filtered_rows,
			"data"    			=> 	$data
		);
			
		echo json_encode($output);

	}
	
	if($_POST["action"] == 'Add')
	{
		$error = '';

		$success = '';
		//
		//$main_query = "
		//SELECT COUNT(nomor)+1 AS nomor FROM surat_keluar 
		//	WHERE jenis_naskah='".$_POST["jenis_naskah"]."' ";
		//
		$main_query="SELECT * FROM pejabat INNER JOIN tanda_tangan WHERE pejabat.kelas_jabatan=tanda_tangan.id_ttd AND id_pejabat='".$_POST["tanda_tangan"]."' ";
		
		$object->query = $main_query ;
		$object->execute();
		$result = $object->get_result();
		//$data2 = array();
		//$nomor_naskah='';
		$kode_ttd = '';
		$jabatan='';
		//$qrcode='';
		$nama_pejabat='';
		$format_nomor='';
		$template_docx='';
		//
		//foreach($result as $row)
		//{
		//	$nomor_naskah = $row["nomor"];
		//}
		foreach ($result as $row) {
			$kode_ttd = $row["kode_ttd"];
			$jabatan  = $row["nama_jabatan"];
			$nama_pejabat= $row["nama_pejabat"];
			//$qrcode=$row["qrcode"];
		}
		//
		$bulan = array (
		1 =>   'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'	);
		$pecahkan = explode('-', date("Y-m-d"));
		//echo $pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0];
		//
		IF($_POST["jenis_naskah"]=='SDinas'){
			$format_nomor = 
			'B-     /XI/'.$kode_ttd.'/'.$_POST["klasifikasi"].'/'. date("Y").'/BNN';
			$templateProcessor = new TemplateProcessor('../docx/template_SDinas_kosong.docx');
			$templateProcessor->setValue('nomor',$format_nomor);
			$templateProcessor->setValue('perihal',$_POST['perihal']);
			$templateProcessor->setValue('tanggal',$pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0]);
			$templateProcessor->setValue('jabatan',$jabatan);
			$templateProcessor->setValue('nama_pejabat',$nama_pejabat);
			
			$template_docx='../docx/result_SDinas'.date("ymhis").'.docx';
			$templateProcessor->saveAs($template_docx);
			//
			//
		} 
		elseif($_POST["jenis_naskah"]=='ND'){
			$format_nomor = 
			'B/ND-     /XI/'.$kode_ttd.'/'.$_POST["klasifikasi"].'/'. date("Y").'/BNN';
			$templateProcessor = new TemplateProcessor('../docx/template_ND_kosong.docx');
			$templateProcessor->setValue('nomor',$format_nomor);
			$templateProcessor->setValue('perihal',$_POST['perihal']);
			$templateProcessor->setValue('tanggal',$pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0]);
			$templateProcessor->setValue('jabatan',$jabatan);
			$templateProcessor->setValue('nama_pejabat',$nama_pejabat);

			$template_docx='../docx/result_ND'.date("ymhis").'.docx';
			$templateProcessor->saveAs($template_docx);
			//
			//
		}
		elseif($_POST["jenis_naskah"]=='SE') {
			$format_nomor = 
			$_POST["jenis_naskah"].'/     /XI/'.$kode_ttd.'/'.$_POST["klasifikasi"].'/'. date("Y").'/BNN';
			//
			//
			$templateProcessor = new TemplateProcessor('../docx/template_SE_kosong.docx');
			$templateProcessor->setValue('nomor',$format_nomor);
			$templateProcessor->setValue('perihal',$_POST['perihal']);
			$templateProcessor->setValue('tanggal',$pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0]);
			$templateProcessor->setValue('jabatan',$jabatan);
			$templateProcessor->setValue('nama_pejabat',$nama_pejabat);
			
			$template_docx='../docx/result_SE'.date("ymhis").'.docx';
			$templateProcessor->saveAs($template_docx);
			//
			//
		}
		elseif($_POST["jenis_naskah"]=='Sprin1') {
			$format_nomor = 
			'Sprin/     /XI/'.$kode_ttd.'/'.$_POST["klasifikasi"].'/'. date("Y").'/BNN';
			//
			//
			$templateProcessor = new TemplateProcessor('../docx/template_Sprin1_kosong.docx');
			$templateProcessor->setValue('nomor',$format_nomor);
			$templateProcessor->setValue('perihal',$_POST['perihal']);
			$templateProcessor->setValue('tanggal',$pecahkan[2] . ' ' . $bulan[ (int)$pecahkan[1] ] . ' ' . $pecahkan[0]);
			$templateProcessor->setValue('jabatan',$jabatan);
			$templateProcessor->setValue('nama_pejabat',$nama_pejabat);
			
			$template_docx='../docx/result_Sprin'.date("ymhis").'.docx';
			$templateProcessor->saveAs($template_docx);
			//
			//
		}

		$data = array(
		':jenis_naskah'		=>	$object->clean_input($_POST["jenis_naskah"]),
		':klasifikasi'		=>	$object->clean_input($_POST["klasifikasi"]),
		':perihal'			=>	$object->clean_input($_POST["perihal"]),
		':tujuan'			=>	$object->clean_input($_POST["tujuan"]),
		':satker'			=>	$object->clean_input($_POST["satker"]),
		':tanggal'			=>	$object->clean_input($_POST["tanggal"]),
		':id_pejabat'		=>  $object->clean_input($_POST["tanda_tangan"]),
		':tanda_tangan'		=>	$kode_ttd,
		':nomor'			=> 	$format_nomor,
		':template_docx'	=> 	$template_docx
		);
		
		
		$object->query = "
		INSERT INTO surat_keluar (jenis_naskah, nomor, perihal,tujuan,klasifikasi,satker, tanggal, ttd,template,id_pejabat) 
		VALUES (:jenis_naskah, :nomor, :perihal,:tujuan, :klasifikasi, :satker, :tanggal, :tanda_tangan,:template_docx,:id_pejabat)
		";

		$object->execute($data);

		$success = '<div class="alert alert-success">Data Added</div>';
			
		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);

		echo json_encode($output);

	}

	if($_POST["action"] == 'fetch_single')
	{
		$object->query = "
		SELECT id_surat,kode_naskah,jenis_naskah.jenis_naskah,nomor,perihal,tujuan,klasifikasi,kode_satker,satuan_kerja,tanggal,kode_ttd,surat_keluar.id_pejabat,nama_pejabat,tanda_tangan,template,surat_keluar.status FROM surat_keluar INNER JOIN jenis_naskah,satuan_kerja,tanda_tangan,pejabat WHERE surat_keluar.jenis_naskah=jenis_naskah.kode_naskah AND satuan_kerja.kode_satker=surat_keluar.satker AND ttd=tanda_tangan.kode_ttd AND surat_keluar.id_pejabat=pejabat.id_pejabat AND id_surat = '".$_POST["no_urut"]."'
		";

		$result = $object->get_result();

		$data = array();

		foreach($result as $row)
		{
			$data['jenis_naskah'] = $row['kode_naskah'];
			$data['klasifikasi'] = $row['klasifikasi'];
			$data['perihal'] = $row['perihal'];
			$data['tujuan'] = $row['tujuan'];
			$data['satker'] = $row['kode_satker'];
			$data['tanggal'] = $row['tanggal'];
			$data['tanda_tangan'] = $row['id_pejabat'];
			$data['nomor'] = $row['nomor'];
		}

		echo json_encode($data);
	
	}
	
	if($_POST["action"] == 'Edit')
	{
		$error = '';
		$success = '';
		//
		$data = array(
			//':unit_kerja'	=>	$_POST["unit_kerja"],
			':no_urut'			=>	$_POST['hidden_id']
		);
		$object->query = "
		SELECT * FROM surat_keluar WHERE id_surat = :no_urut 
		";
		$object->execute($data);
		if($object->row_count() > 0)
		{
			//
			$allowed_file_format = array("pdf");
			$file_extension = pathinfo($_FILES["nama_naskah"]["name"], PATHINFO_EXTENSION);
			if(!in_array($file_extension, $allowed_file_format))
		    {
		        $error = "<div class='alert alert-danger'>Upload hanya file .pdf</div>";
		    }
		    else if (($_FILES["nama_naskah"]["size"] > 2000000))
		    {
		       $error = "<div class='alert alert-danger'>Ukuran File maksimum 2MB</div>";
		    }
		    else
		    {
		    	//$new_name = rand() . '.' . $file_extension;
				$destination = '../docx/' . $_FILES['nama_naskah']['name'];
				move_uploaded_file($_FILES['nama_naskah']['tmp_name'], $destination);
				$nama_naskah = $destination;
				//
				$data = array(
					':nama_naskah'		=>	$nama_naskah,
				);
				$object->query = 'UPDATE surat_keluar SET template = :nama_naskah
				WHERE id_surat = '.$_POST['hidden_id'];

				$object->execute($data);
				
				$success = '<div class="alert alert-success">Data Updated </div>';
		    }
		}
		//
		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);
		echo json_encode($output);
	}

	if($_POST["action"] == 'beri_nomor')
	{
		//
		$nomor_naskah='';
		$format_nomor = '';
		$main_query = "
		SELECT COUNT(nomor)+1 AS nomor FROM surat_keluar 
			WHERE jenis_naskah='".$_POST["jenis_naskah"]."' AND status='1' ";
		$object->query = $main_query ;
		$object->execute();
		$result = $object->get_result();
		foreach($result as $row)
		{
			$nomor_naskah = $row["nomor"];
		}
		//if($nomor_naskah==2) $nomor_naskah=1;
		//
		$main_query2 = "
		SELECT klasifikasi,satuan_kerja,tanggal,kode_ttd FROM surat_keluar INNER JOIN jenis_naskah,satuan_kerja,tanda_tangan WHERE surat_keluar.jenis_naskah=jenis_naskah.kode_naskah AND satuan_kerja.kode_satker=surat_keluar.satker AND ttd=tanda_tangan.kode_ttd
			AND id_surat = '".$_POST["id"]."' ";
		$object->query = $main_query2 ;
		$object->execute();
		$result2 = $object->get_result();
		$klasifikasi='';
		$ttd='';
		foreach($result2 as $row)
		{
			$klasifikasi = $row["klasifikasi"];
			$ttd= $row["kode_ttd"];
		}
		//
		$array_bln	= array(1=>"I","II","III", "IV", "V","VI","VII","VIII","IX","X", "XI","XII");
		$bln		= $array_bln[date('n')];
		//
		IF($_POST["jenis_naskah"]=='SDinas'){
			$format_nomor = 'B-'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='ND'){
			$format_nomor = 'B/ND-'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='SE') {
			$format_nomor = 'SE/'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='Sprin1') {
			$format_nomor = 'Sprin/'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		}
		//
		$data = array(
			':nomor'	=>	$format_nomor
		);
		
		$object->query = 'UPDATE surat_keluar SET nomor =:nomor,status=1 WHERE id_surat = '.$_POST["id"];

		$object->execute($data);

		echo '<div class="alert alert-success">Nomor Surat sudah diberikan '.$format_nomor.'</div>';
	
	}
}

?>