<?php

//olah.php

include('../class/Appointment.php');

$object = new Appointment;

if(!$object->is_login())
{
    header("location:".$object->base_url."admin");
}

/*if($_SESSION['arsiparis_type'] != 'Admin')
	{
		header("location:".$object->base_url."");
	}*/
$object->query = "SELECT * FROM jenis_naskah ";
$result = $object->get_result();
include('header.php');

?>
<span id="message"></span>
<div class="card shadow mb-4">
	<div class="card-header py-3">
		<div class="row">
			<div class="col">
				<h6 class="m-0 font-weight-bold text-primary">Template Naskah</h6>
			</div>
			<div class="col" align="right">
				<button type="button" name="add_data" id="add_data" class="btn btn-success btn-circle btn-sm"><i class="fas fa-plus"></i></button>
			</div>
		</div>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table id="user_data" class="table table-bordered" width="100%" cellspacing="0">
			 <thead>
			  <tr>
			   <th>jenis naskah</th>
			   <th>nama naskah</th>
			   <th>file</th>
			   <th></th>
			  </tr>
			 </thead>
			 <tbody>
             </tbody>
			</table>
		</div>
	</div>
</div>

<?php
include('footer.php');
?>
<div id="dataModal"  class="modal fade">
  	<div class="modal-dialog">
    	<form method="post" id="data_form">
      		<div class="modal-content">
        		<div class="modal-header">
          			<h4 class="modal-title" id="modal_title">Tambah Data</h4>
          			<button type="button" class="close" data-dismiss="modal">&times;</button>
        		</div>
        		<div class="modal-body">
        			<span id="form_message"></span>
		          	<div class="form-group">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Jenis Naskah <span class="text-danger">*</span></label>
								<select class="form-control selectpicker" name="jenis_naskah" id="jenis_naskah"  data-live-search="true" data-size="5" data-allow-clear="true" data-noneSelectedText="Pilih Jenis Naskah" required>
									<option value="">Pilih Jenis Naskah</option>
                                    <?php foreach($result as $row)
									{
										echo '<option value="'.$row["kode_naskah"].'">'.$row["jenis_naskah"].'</option>';
									}
                                    ?>
                                </select>
                                <!--input type="text" name="unit_kerja" id="unit_kerja" class="form-control" required  data-parsley-trigger="keyup" /-->
                            </div>
							<div class="col-md-6">
                                <label>File <span class="text-danger"></span></label>
                                <input type="file" name="nama_naskah" id="nama_naskah" required/>
		                        <div id="uploaded_image"></div>
		                        <input type="hidden" name="hidden_nama_naskah" id="hidden_nama_naskah" />
                            </div>
		          		</div>
		          	</div>
									
					<div class="modal-footer">
          			<input type="hidden" name="hidden_id" id="hidden_id" />
          			<input type="hidden" name="action" id="action" value="Add" />
          			<input type="submit" name="submit" id="submit_button" class="btn btn-success" value="Add" />
          			<button type="button" class="btn btn-default" data-dismiss="modal" data-backdrop="static" data-keyboard="false">Close</button>
        		</div>
			</div>
    	</form>
  	</div>
</div>

<script type="text/javascript" language="javascript" >
 $(document).ready(function(){
  
  var dataTable = $('#user_data').DataTable({
		"processing" : true,
		"serverSide" : true,
		"order" : [],
		"ajax" : {
			url:"template_naskah_action.php",
			type:"POST",
			data:{action:'fetch'}
		},
		"columnDefs":[
			{
				"targets":[2,3],
				"orderable":false,
			},
		],
	});
	
	$('#add_data').click(function(){
		
		$('#data_form')[0].reset();

		$('#data_form').parsley().reset();

    	$('#modal_title').text('Tambah Data');

    	$('#action').val('Add');

    	$('#submit_button').val('Simpan');
		
		$('#dataModal').modal({backdrop: 'static', keyboard: false}) ;
    	$('#dataModal').modal('show');

    	$('#form_message').html('');

	});
	
	$('#data_form').parsley();
  
	$(document).on('click', '.edit_button', function(){

		var no_urut = $(this).data('id');

		$('#data_form').parsley().reset();

		$('#form_message').html('');

		$.ajax({

	      	url:"template_naskah_action.php",

	      	method:"POST",

	      	data:{no_urut:no_urut, action:'fetch_single'},

	      	dataType:'JSON',

	      	success:function(data)
	      	{

	        	$('#jenis_naskah').selectpicker( 'val',data.jenis_naskah);
                $('#nama').val(data.unit_kerja);
                
	        	$('#modal_title').text('Ubah Data');

	        	$('#action').val('Edit');

	        	$('#submit_button').val('Ubah');
				
	        	$('#dataModal').modal('show');

	        	$('#hidden_id').val(no_urut);

	      	}

	    })

	});
	
	$('#data_form').on('submit', function(event){
		event.preventDefault();
		if($('#data_form').parsley().isValid())
		{	
			$.ajax({
				url:"template_naskah_action.php",
				method:"POST",
				data: new FormData(this),
				dataType:'json',
                contentType: false,
                cache: false,
                processData:false,
				beforeSend:function()
				{
					$('#submit_button').attr('disabled', 'disabled');
					$('#submit_button').val('wait...');
				},
				success:function(data)
				{
					
					$('#submit_button').attr('disabled', false);
					if(data.error != '')
					{
						$('#form_message').html(data.error);
						$('#submit_button').val('Add');
					}
					else
					{
						$('#dataModal').modal('hide');
						$('#message').html(data.success);
						dataTable.ajax.reload();

						setTimeout(function(){

				            $('#message').html('');

				        }, 5000);
					}
				}
			})
		}
	});
	
	
 
 });
</script>

